/** @file   carcontroller.h
 * @brief   Declaration of CarController class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_CARCONTROLLER_H
#define H_WWW_CARCONTROLLER_H

#include "waypointcontroller.h"


namespace WeWantWar {


/** @class  CarController
 * @brief   Takes care of controlling the civilian Car - objects.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 *
 * If this controller sets nonzero value to the <code>m_shoot'</code> attribute,
 * it means that the car should make the 'horn'-sound.
 */
class CarController : public WaypointController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     pObj              Pointer to GameObject we're supposed to
   *                              control.
   */
	CarController( GameObject* pObj );


	/** Destructor
   */
	virtual ~CarController();


private:

	/** Copy constructor.
   * @param     rO                Reference to another CarController
   */
  CarController( const CarController& rO );

	/** Assignment operator
   * @param     rO                Reference to another CarController
   * @return    Reference to us.
   */
  CarController& operator = ( const CarController& rO );
  
public:



  ///
  /// Methods
  /// =======

  /** Updates this controller.
   */
  virtual void update();
  


  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======

  /** This counter counts how long we've been waiting Player or some other
   * objects to get out of our way.
   */
  int m_waitingCounter;
  
  /** This counter tells, if we're waiting another car. */
  int m_waitingCarCounter;

private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: carcontroller.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:50+02  lamminsa
 * Initial revision
 *
 */
 
